﻿Module Extensions
  <System.Runtime.CompilerServices.Extension()>
  Friend Function GetAllControlsOfType(Of T As Control)(ByVal controls As Control.ControlCollection) As T()
    Dim controlsArray(controls.Count - 1) As Control
    controls.CopyTo(controlsArray, 0)
    Dim oldControlSieveList As New List(Of Control)(controlsArray)
    Dim newControlSieveList As List(Of Control)
    Dim targetControlList As New List(Of T)
    While oldControlSieveList.Count > 0
      newControlSieveList = New List(Of Control)
      For Each parentControl As Control In oldControlSieveList
        If parentControl.HasChildren Then
          For Each childControl As Control In parentControl.Controls
            newControlSieveList.Add(childControl)
          Next
        End If
        If TypeOf parentControl Is T Then targetControlList.Add(parentControl)
      Next
      oldControlSieveList = newControlSieveList
    End While
    Return targetControlList.ToArray
  End Function
End Module